%  Calculates the diffuse and specular components for a given point

lightSource = [-1, 1, 0; -1, 2, 3];
pointHit = [0, 0, 0; 1, -1, 1.5];
normal = [0, 1, 0; 0.5, 1, -0.5];
eye = [1, 1, 0; 2, -1.5, 2];
lightIntensity = [1.0, 0.5, 0.1];
falloff = [1, 3];

for i=1:2
    s = lightSource(i,:) - pointHit(i,:);
    m = normal(i, :);

    numerator = dot(s, m);
    denominator = sqrt(dot(s,s)) * sqrt (dot(m,m));
    fraction=numerator/denominator
    diffuse= max([0, fraction]) .* lightIntensity 

    %  Now compute the specular intensity
    v = eye(i,:) - pointHit(i,:);
    numerator = dot(s,m);
    denominator = dot(m, m);

    r = -1*s + (2*numerator/denominator)*m
    numerator = max([0, dot(r,v)]);
    denominator = sqrt(dot(r,r))*sqrt(dot(v,v));
    specular = ((numerator/denominator)^falloff(i)) * lightIntensity;
    fprintf ('Diffuse is %5.5f\n', diffuse);
    fprintf ('Specular is %5.5f\n', specular);
end
